from bpy.types import Panel
# from ...addon.naming import FluidLabNaming
from ..ui_module_panel import FLUIDLAB_ModulePanel
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.common_ui_elements import title_header, collapsable, multiline_print
from ...libs.functions.animation import draw_anim_props


class FLUIDLAB_PT_fluid_colliders_ui(Panel, FLUIDLAB_ModulePanel):
    fluidlab_section = 'COLLIDERS'
    bl_idname = "FLUIDLAB_PT_fluid_colliders_ui"
    bl_label = "Module"

    def draw(self, context):

        fluid_colliders, ui, toggles = get_common_vars(context, get_fluid_colliders=True, get_ui=True, get_toggles=True)

        layout = self.layout
        layout.use_property_split = True
        layout.use_property_decorate = False

        col = layout.column(align=True)
        title_header(col, "Colliders")

        main_col = col.box().column(align=True)
        main_col.use_property_split = True
        main_col.use_property_decorate = False

        # -------------------------------------------------------------------------------
        # ## UI BASICA ##
        # ------------------------------------------------------------------------------- 
        if ui.ui_mode == 'BASIC':
            main_col.label(text="Hola Mundo Basico")

        # -------------------------------------------------------------------------------
        # ## UI AVANZADA ##
        # ------------------------------------------------------------------------------- 
        elif ui.ui_mode == 'ADVANCED':

            main_col.template_list("FLUIDLAB_UL_draw_fluids_colliders", "", fluid_colliders, "list", fluid_colliders, "list_index", rows=3)
            add_bt = main_col.row(align=True)
            add_bt.scale_y = 1.3
            add_bt.operator("fluidlab.fluid_colliders_list_add_single", text="Add Selection Collider")
            add_bt.operator("fluidlab.fluid_colliders_list_add_gn_collider", text="Add GN Collider")

            if not fluid_colliders.is_void:

                active_collider = fluid_colliders.active
                if active_collider:

                    switcher_subsections = layout.row(align=True)
                    switcher_subsections.use_property_split = False
                    switcher_subsections.scale_y = 1.3
                    switcher_subsections.prop(active_collider.settings, "subsections", expand=True)
                    
                    if active_collider.settings.subsections == 'SETTINGS':

                        c_settings = collapsable(
                            layout,
                            toggles,
                            "cs_collider_settings",
                            "Collider Settings",
                            'SETTINGS', # TOOL_SETTINGS
                            align=True,
                        )
                        if c_settings:

                            perm = c_settings.row(align=True)
                            perm.prop(active_collider.settings, "permeability", text="Permeability", slider=True)
                            perm.enabled = not active_collider.animation.permeability_animed

                            stick = c_settings.row(align=True)
                            stick.prop(active_collider.settings, "stickiness", text="Stickiness")
                            stick.enabled = not active_collider.animation.stickiness_animed
                            
                            c_settings.prop(active_collider.settings, "use_particle_kill", text="OutFlow (Kill Particles)", toggle=True)

                            # if active_collider.settings.use_particle_kill:
                            #     c_settings.separator()
                            #     text=f"It will be necessary to use the Bake button in animation mode of the BakeAnim node inside the Geometry Nodes Mesh."
                            #     multiline_print(c_settings, text, 6, 'INFO')

                            c_settings.separator()
                            
                            damp = c_settings.row(align=True)
                            damp.prop(active_collider.settings, "damping_factor", text="Damping", slider=True)
                            damp.enabled = not active_collider.animation.damping_factor_animed

                            c_settings.prop(active_collider.settings, "damping_random", text="Randomize Damping", slider=True)
                            c_settings.separator(factor=0.5)
                            
                            frict = c_settings.row(align=True)
                            frict.prop(active_collider.settings, "friction_factor", text="Friction", slider=True)
                            frict.enabled = not active_collider.animation.friction_factor_animed

                            c_settings.prop(active_collider.settings, "friction_random", text="Randomize Friction", slider=True)
                    
                    elif active_collider.settings.subsections == 'ANIMATION':

                        anim_col = layout.column(align=True)
                        section = "colliders"

                        props = ["permeability", "stickiness", "damping_factor", "friction_factor", "enable_disable"]
                        
                        for prop_slug in props:
                            
                            prop_name =  prop_slug.replace("_factor", "").replace("_", " ")

                            props_anim = collapsable(
                                layout=anim_col,
                                contain_prop=toggles,
                                show_hide_str="ca_" + section + "_anim_" + prop_slug,
                                mytext=prop_name.title(),
                                myicon='KEYINGSET',
                                align=True,
                            )
                            if props_anim:
                                draw_anim_props(props_anim, "animation", active_collider.animation, prop_slug, "fluidlab.colliders_animation_buttons")